// Craig S. Kaplan
// An example of rotating about arbitrary points.
// Click on a point in the sketch window to set it
// as the anchor point for rotation.  Use a 
// rotateAboutPoint() helper function to streamline
// the transformation process.

float cx = 250;
float cy = 250;

void rotateAboutPoint( float x, float y, float theta )
{
  translate( x, y );
  rotate( radians( theta ) );
  translate( -x, -y );
}

void setup()
{
  size( 500, 500 );
}

void draw()
{
  background( 80 );
  pushMatrix();
  rotateAboutPoint( cx, cy, frameCount );
  rect( 100, 200, 300, 100 );
  popMatrix();
}

void mousePressed()
{
  cx = mouseX;
  cy = mouseY;
}